/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class ElectricFieldPower
extends AbstractPower {
    public static final String POWER_ID = "Electric Field";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Electric Field");
    public static final String NAME = ElectricFieldPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = ElectricFieldPower.powerStrings.DESCRIPTIONS;
    private DamageInfo thornsInfo;

    public ElectricFieldPower(String newName, AbstractCreature owner, int chargeReq) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = chargeReq;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/thorns.png");
        this.thornsInfo = new DamageInfo(owner, 1, DamageInfo.DamageType.THORNS);
    }

    @Override
    public void stackPower(int stackAmount) {
        this.amount -= stackAmount;
        if (this.amount < 1) {
            this.amount = 1;
            return;
        }
        this.fontScale = 8.0f;
        this.updateDescription();
    }

    @Override
    public int onAttacked(DamageInfo info, int damageAmount) {
        if (info.type != DamageInfo.DamageType.THORNS && info.type != DamageInfo.DamageType.HP_LOSS && info.owner != null && info.owner != this.owner) {
            this.flash();
            for (int i = 0; i < AbstractDungeon.player.charge / this.amount; ++i) {
                AbstractDungeon.actionManager.addToTop(new DamageAction(info.owner, this.thornsInfo, AbstractGameAction.AttackEffect.BLUNT_LIGHT));
            }
        }
        return damageAmount;
    }

    @Override
    public void updateDescription() {
        this.description = this.amount != 1 ? DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1] : DESCRIPTIONS[2];
    }
}

